﻿#include  "StdAfx.h"

#include  <szFileArchiveVolume.hpp>
#include  <7zip/Common/FileStreams.h>

SZ_NS_BEG(szpp)

FileArchiveVolume::FileArchiveVolume(const szstring &path) : path(path)
{
}

FileArchiveVolume::~FileArchiveVolume()
{
}

const szstring &FileArchiveVolume::DoGetVirtualPath() const
{
  return path;
}

void FileArchiveVolume::DoSetVirtualPath(const szstring & path)
{
  this->path = path;
}

HRESULT FileArchiveVolume::DoGetArchiveStream(IInStream ** ppStream)
{
  if (0 == ppStream)
    return E_POINTER;

  try
  {
    CMyComPtr<CInFileStream> stream(new CInFileStream());
    stream->Open(path.c_str());
    UInt64 size;
    HRESULT hr = stream->GetSize(&size);
    *ppStream = stream.Detach();
    return S_OK;
  }
  catch (...)
  {
    return E_FAIL;
  }
}

SZ_NS_END(szpp)
